// priority: 100
onEvent("recipes", (event) => {

    const addMissingCrushingRecipes = (crushedOre, ore, deepOre, rawOre, rawOreBlock) => {
        event.recipes.createCrushing([Item.of(crushedOre, 1), Item.of(crushedOre, 1).withChance(0.75), Item.of('create:experience_nugget', 1).withChance(0.75), Item.of('minecraft:cobblestone', 1).withChance(0.125)], ore).processingTime(250)
        event.recipes.createCrushing([Item.of(crushedOre, 2), Item.of(crushedOre, 1).withChance(0.25), Item.of('create:experience_nugget', 1).withChance(0.75), Item.of('minecraft:cobbled_deepslate', 1).withChance(0.125)], deepOre).processingTime(350)
        event.recipes.createCrushing([Item.of(crushedOre, 1), Item.of('create:experience_nugget', 1).withChance(0.75)], rawOre).processingTime(400)
        event.recipes.createCrushing([Item.of(crushedOre, 9), Item.of('create:experience_nugget', 9).withChance(0.75)], rawOreBlock).processingTime(400)
    };

    addMissingCrushingRecipes('create:crushed_silver_ore', 'thermal:silver_ore', 'thermal:deepslate_silver_ore', '#forge:raw_materials/silver', '#forge:storage_blocks/raw_silver')
    addMissingCrushingRecipes('create:crushed_tin_ore', 'thermal:tin_ore', 'thermal:deepslate_tin_ore', '#forge:raw_materials/tin', '#forge:storage_blocks/raw_tin')
    addMissingCrushingRecipes('create:crushed_lead_ore', 'thermal:lead_ore', 'thermal:deepslate_lead_ore', '#forge:raw_materials/lead', '#forge:storage_blocks/raw_lead')
    addMissingCrushingRecipes('create:crushed_aluminum_ore', 'immersiveengineering:ore_aluminum', 'immersiveengineering:deepslate_ore_aluminum', 'immersiveengineering:raw_aluminum', '#forge:storage_blocks/raw_aluminum')
    addMissingCrushingRecipes('create:crushed_uranium_ore', 'mekanism:uranium_ore', 'mekanism:deepslate_uranium_ore', 'mekanism:raw_uranium', '#forge:storage_blocks/raw_uranium')
    addMissingCrushingRecipes('create:crushed_nickel_ore', 'thermal:nickel_ore', 'thermal:deepslate_nickel_ore', '#forge:raw_materials/nickel', '#forge:storage_blocks/raw_nickel')
    addMissingCrushingRecipes('create:crushed_osmium_ore', 'mekanism:osmium_ore', 'mekanism:deepslate_osmium_ore', 'mekanism:raw_osmium', '#forge:storage_blocks/raw_osmium')

    //Dead Coral Blocks
    event.recipes.createFilling('minecraft:tube_coral_block', [
        'minecraft:dead_tube_coral_block',
        Fluid.of("minecraft:water", 1000),
    ]);
    event.recipes.createFilling('minecraft:brain_coral_block', [
        'minecraft:dead_brain_coral_block',
        Fluid.of("minecraft:water", 1000),
    ]);
    event.recipes.createFilling('minecraft:bubble_coral_block', [
        'minecraft:dead_bubble_coral_block',
        Fluid.of("minecraft:water", 1000),
    ]);
    event.recipes.createFilling('minecraft:fire_coral_block', [
        'minecraft:dead_fire_coral_block',
        Fluid.of("minecraft:water", 1000),
    ]);
    event.recipes.createFilling('minecraft:horn_coral_block', [
        'minecraft:dead_horn_coral_block',
        Fluid.of("minecraft:water", 1000),
    ]);

    //Dead Coral
    event.recipes.createFilling('minecraft:brain_coral', [
        'minecraft:dead_brain_coral',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:bubble_coral', [
        'minecraft:dead_bubble_coral',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:fire_coral', [
        'minecraft:dead_fire_coral',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:horn_coral', [
        'minecraft:dead_horn_coral',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:tube_coral', [
        'minecraft:dead_tube_coral',
        Fluid.of("minecraft:water", 600),
    ]);

    //Dead Coral Fans
    event.recipes.createFilling('minecraft:tube_coral_fan', [
        'minecraft:dead_tube_coral_fan',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:brain_coral_fan', [
        'minecraft:dead_brain_coral_fan',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:bubble_coral_fan', [
        'minecraft:dead_bubble_coral_fan',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:fire_coral_fan', [
        'minecraft:dead_fire_coral_fan',
        Fluid.of("minecraft:water", 600),
    ]);
    event.recipes.createFilling('minecraft:horn_coral_fan', [
        'minecraft:dead_horn_coral_fan',
        Fluid.of("minecraft:water", 600),
    ]);

    //Sturdy sheet recipe fix to include obsidian tag instead of item
    event.custom(
        {
            "type": "create:sequenced_assembly",
            "ingredient": {
                "tag": "forge:dusts/obsidian"
            },
            "transitionalItem": {
                "item": "create:unprocessed_obsidian_sheet"
            },
            "sequence": [
                {
                    "type": "create:filling",
                    "ingredients": [
                        {
                            "item": "create:unprocessed_obsidian_sheet"
                        },
                        {
                            "fluid": "minecraft:lava",
                            "nbt": {},
                            "amount": 500
                        }
                    ],
                    "results": [
                        {
                            "item": "create:unprocessed_obsidian_sheet"
                        }
                    ]
                },
                {
                    "type": "create:pressing",
                    "ingredients": [
                        {
                            "item": "create:unprocessed_obsidian_sheet"
                        }
                    ],
                    "results": [
                        {
                            "item": "create:unprocessed_obsidian_sheet"
                        }
                    ]
                },
                {
                    "type": "create:pressing",
                    "ingredients": [
                        {
                            "item": "create:unprocessed_obsidian_sheet"
                        }
                    ],
                    "results": [
                        {
                            "item": "create:unprocessed_obsidian_sheet"
                        }
                    ]
                }
            ],
            "results": [
                {
                    "item": "create:sturdy_sheet"
                }
            ],
            "loops": 1
        }
    ).id('create:sequenced_assembly/sturdy_sheet');
});